package ru.yandex.webmaster3.storage.download.searchquery;


import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.LocalDate;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.download.FileFormat;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;
import ru.yandex.webmaster3.storage.searchquery.AggregatePeriod;
import ru.yandex.webmaster3.storage.searchquery.DeviceType;
import ru.yandex.webmaster3.storage.searchquery.RegionInclusion;

import java.util.UUID;

/**
 * Created by ifilippov5 on 07.03.17.
 */
public class DownloadSelectedGroupStatisticTaskData extends AbstractDownloadQueryStatisticTaskData {
    private final String groupId;
    private final AggregatePeriod period;

    public DownloadSelectedGroupStatisticTaskData(@JsonProperty("taskId") UUID taskId,
                                                  @JsonProperty("hostId") WebmasterHostId hostId,
                                                  @JsonProperty("localDateFrom") LocalDate localDateFrom,
                                                  @JsonProperty("localDateTo") LocalDate localDateTo,
                                                  @JsonProperty("regionId") Integer[] regionId,
                                                  @JsonProperty("regionInclusion") RegionInclusion regionInclusion,
                                                  @JsonProperty("groupId") String groupId,
                                                  @JsonProperty("deviceType") DeviceType deviceType,
                                                  @JsonProperty("period") AggregatePeriod period,
                                                  @JsonProperty("exportFormat") FileFormat exportFormat,
                                                  @JsonProperty("fileName") String fileName,
                                                  @JsonProperty("hash") Long hash) {
        super(taskId, hostId, localDateFrom, localDateTo, regionId, regionInclusion, deviceType, exportFormat, fileName, hash);
        this.period = period;
        this.groupId = groupId;
    }

    private DownloadSelectedGroupStatisticTaskData(WebmasterHostId hostId,
                                                   LocalDate localDateFrom,
                                                   LocalDate localDateTo,
                                                   Integer[] regionId,
                                                   RegionInclusion regionInclusion,
                                                   String groupId,
                                                   DeviceType deviceType,
                                                   AggregatePeriod period,
                                                   FileFormat exportFormat,
                                                   String fileName,
                                                   Long hash) {
        super(hostId, localDateFrom, localDateTo, regionId, regionInclusion, deviceType, exportFormat, fileName, hash);
        this.groupId = groupId;
        this.period = period;
    }

    public static WorkerTaskData createTaskData(WebmasterHostId hostId,
                                                LocalDate localDateFrom,
                                                LocalDate localDateTo,
                                                Integer[] regionId,
                                                RegionInclusion regionInclusion,
                                                String groupId,
                                                DeviceType deviceType,
                                                AggregatePeriod period,
                                                FileFormat exportFormat,
                                                String fileName,
                                                Long hash) {
        return new DownloadSelectedGroupStatisticTaskData(hostId,
                localDateFrom,
                localDateTo,
                regionId,
                regionInclusion,
                groupId,
                deviceType,
                period,
                exportFormat,
                fileName,
                hash);
    }

    public String getGroupId() {
        return groupId;
    }

    public AggregatePeriod getPeriod() {
        return period;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.DOWNLOAD_STATISTIC_SELECTED_GROUP_ALL_INDICATORS;
    }

    @Override
    public String getShortDescription() {
        return "Download selected group all indicators";
    }
}
