package ru.yandex.webmaster3.storage.download.searchquery;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.LocalDate;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.download.FileFormat;
import ru.yandex.webmaster3.core.searchquery.QueryIndicator;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;
import ru.yandex.webmaster3.storage.searchquery.AggregatePeriod;
import ru.yandex.webmaster3.storage.searchquery.DeviceType;
import ru.yandex.webmaster3.storage.searchquery.RegionInclusion;

import java.util.UUID;

/**
 * Created by ifilippov5 on 03.03.17.
 */
public class DownloadStatisticIndicatorTaskData extends AbstractDownloadQueryStatisticTaskData {
    private final QueryIndicator indicator;
    private final AggregatePeriod period;

    public DownloadStatisticIndicatorTaskData(@JsonProperty("taskId") UUID taskId,
                                              @JsonProperty("hostId") WebmasterHostId hostId,
                                              @JsonProperty("localDateFrom") LocalDate localDateFrom,
                                              @JsonProperty("localDateTo") LocalDate localDateTo,
                                              @JsonProperty("regionId") Integer[] regionId,
                                              @JsonProperty("regionInclusion") RegionInclusion regionInclusion,
                                              @JsonProperty("indicator") QueryIndicator indicator,
                                              @JsonProperty("deviceType") DeviceType deviceType,
                                              @JsonProperty("period") AggregatePeriod period,
                                              @JsonProperty("exportFormat") FileFormat exportFormat,
                                              @JsonProperty("fileName") String fileName,
                                              @JsonProperty("hash") Long hash) {
        super(taskId, hostId, localDateFrom, localDateTo, regionId, regionInclusion, deviceType, exportFormat, fileName, hash);
        this.indicator = indicator;
        this.period = period;
    }

    private DownloadStatisticIndicatorTaskData(WebmasterHostId hostId,
                                           LocalDate localDateFrom,
                                           LocalDate localDateTo,
                                           Integer[] regionId,
                                           RegionInclusion regionInclusion,
                                           QueryIndicator indicator,
                                           DeviceType deviceType,
                                           AggregatePeriod period,
                                           FileFormat exportFormat,
                                           String fileName,
                                           Long hash) {
        super(hostId, localDateFrom, localDateTo, regionId, regionInclusion, deviceType, exportFormat, fileName, hash);
        this.indicator = indicator;
        this.period = period;
    }

    public static WorkerTaskData createTaskData(WebmasterHostId hostId,
                                                LocalDate localDateFrom,
                                                LocalDate localDateTo,
                                                Integer[] regionId,
                                                RegionInclusion regionInclusion,
                                                QueryIndicator indicator,
                                                DeviceType deviceType,
                                                AggregatePeriod period,
                                                FileFormat exportFormat,
                                                String fileName,
                                                Long hash) {
        return new DownloadStatisticIndicatorTaskData(hostId,
                localDateFrom,
                localDateTo,
                regionId,
                regionInclusion,
                indicator,
                deviceType,
                period,
                exportFormat,
                fileName,
                hash);
    }

    public QueryIndicator getIndicator() {
        return indicator;
    }

    public AggregatePeriod getPeriod() {
        return period;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.DOWNLOAD_STATISTIC_ALL_GROUPS_ONE_INDICATOR;
    }

    @Override
    public String getShortDescription() {
        return "Download group with one indicator";
    }
}
