package ru.yandex.webmaster3.storage.download.searchquery;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.LocalDate;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.download.FileFormat;
import ru.yandex.webmaster3.core.searchquery.QueryId;
import ru.yandex.webmaster3.core.searchquery.SpecialGroup;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;
import ru.yandex.webmaster3.storage.searchquery.AggregatePeriod;
import ru.yandex.webmaster3.storage.searchquery.DeviceType;
import ru.yandex.webmaster3.storage.searchquery.RegionInclusion;

import java.util.UUID;

/**
 * Created by ifilippov5 on 08.03.17.
 */
public class DownloadStatisticSelectedQueryAllIndicatorsTaskData extends AbstractDownloadQueryStatisticTaskData {
    private final AggregatePeriod period;
    private final SpecialGroup specialGroup;
    private final QueryId queryId;

    public DownloadStatisticSelectedQueryAllIndicatorsTaskData(@JsonProperty("taskId") UUID taskId,
                                                               @JsonProperty("hostId") WebmasterHostId hostId,
                                                               @JsonProperty("localDateFrom") LocalDate localDateFrom,
                                                               @JsonProperty("localDateTo") LocalDate localDateTo,
                                                               @JsonProperty("regionId") Integer[] regionId,
                                                               @JsonProperty("regionInclusion") RegionInclusion regionInclusion,
                                                               @JsonProperty("specialGroup") SpecialGroup specialGroup,
                                                               @JsonProperty("queryId") QueryId queryId,
                                                               @JsonProperty("deviceType") DeviceType deviceType,
                                                               @JsonProperty("period") AggregatePeriod period,
                                                               @JsonProperty("exportFormat") FileFormat exportFormat,
                                                               @JsonProperty("fileName") String fileName,
                                                               @JsonProperty("hash") Long hash) {
        super(taskId, hostId, localDateFrom, localDateTo, regionId, regionInclusion, deviceType, exportFormat, fileName, hash);
        this.period = period;
        this.specialGroup = specialGroup;
        this.queryId = queryId;
    }

    private DownloadStatisticSelectedQueryAllIndicatorsTaskData(WebmasterHostId hostId,
                                                                LocalDate localDateFrom,
                                                                LocalDate localDateTo,
                                                                Integer[] regionId,
                                                                RegionInclusion regionInclusion,
                                                                SpecialGroup specialGroup,
                                                                QueryId queryId,
                                                                DeviceType deviceType,
                                                                AggregatePeriod period,
                                                                FileFormat exportFormat,
                                                                String fileName,
                                                                Long hash) {
        super(hostId, localDateFrom, localDateTo, regionId, regionInclusion, deviceType, exportFormat, fileName, hash);
        this.period = period;
        this.specialGroup = specialGroup;
        this.queryId = queryId;
    }

    public static WorkerTaskData createTaskData(WebmasterHostId hostId,
                                                LocalDate localDateFrom,
                                                LocalDate localDateTo,
                                                Integer[] regionId,
                                                RegionInclusion regionInclusion,
                                                SpecialGroup specialGroup,
                                                QueryId queryId,
                                                DeviceType deviceType,
                                                AggregatePeriod period,
                                                FileFormat exportFormat,
                                                String fileName,
                                                Long hash) {
        return new DownloadStatisticSelectedQueryAllIndicatorsTaskData(hostId,
                localDateFrom,
                localDateTo,
                regionId,
                regionInclusion,
                specialGroup,
                queryId,
                deviceType,
                period,
                exportFormat,
                fileName,
                hash);
    }

    public SpecialGroup getSpecialGroup() {
        return specialGroup;
    }

    public QueryId getQueryId() {
        return queryId;
    }

    public AggregatePeriod getPeriod() {
        return period;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.DOWNLOAD_STATISTIC_SELECTED_QUERY_ALL_INDICATORS;
    }

    @Override
    public String getShortDescription() {
        return "Download selected query all indicators";
    }
}
