package ru.yandex.webmaster3.storage.download.searchquery;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.LocalDate;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.download.FileFormat;
import ru.yandex.webmaster3.core.searchquery.PathId;
import ru.yandex.webmaster3.core.searchquery.SpecialGroup;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;
import ru.yandex.webmaster3.storage.searchquery.AggregatePeriod;
import ru.yandex.webmaster3.storage.searchquery.DeviceType;
import ru.yandex.webmaster3.storage.searchquery.RegionInclusion;

import java.util.UUID;

/**
 * @author lester
 */
public class DownloadStatisticSelectedUrlAllIndicatorsTaskData extends AbstractDownloadQueryStatisticTaskData {
    private final AggregatePeriod period;
    private final SpecialGroup specialGroup;
    private final PathId pathId;

    public DownloadStatisticSelectedUrlAllIndicatorsTaskData(@JsonProperty("taskId") UUID taskId,
                                                             @JsonProperty("hostId") WebmasterHostId hostId,
                                                             @JsonProperty("localDateFrom") LocalDate localDateFrom,
                                                             @JsonProperty("localDateTo") LocalDate localDateTo,
                                                             @JsonProperty("regionId") Integer[] regionId,
                                                             @JsonProperty("regionInclusion") RegionInclusion regionInclusion,
                                                             @JsonProperty("specialGroup") SpecialGroup specialGroup,
                                                             @JsonProperty("pathId") PathId pathId,
                                                             @JsonProperty("deviceType") DeviceType deviceType,
                                                             @JsonProperty("period") AggregatePeriod period,
                                                             @JsonProperty("exportFormat") FileFormat exportFormat,
                                                             @JsonProperty("fileName") String fileName,
                                                             @JsonProperty("hash") Long hash) {
        super(taskId, hostId, localDateFrom, localDateTo, regionId, regionInclusion, deviceType, exportFormat, fileName, hash);
        this.period = period;
        this.specialGroup = specialGroup;
        this.pathId = pathId;
    }

    private DownloadStatisticSelectedUrlAllIndicatorsTaskData(WebmasterHostId hostId,
                                                              LocalDate localDateFrom,
                                                              LocalDate localDateTo,
                                                              Integer[] regionId,
                                                              RegionInclusion regionInclusion,
                                                              SpecialGroup specialGroup,
                                                              PathId pathId,
                                                              DeviceType deviceType,
                                                              AggregatePeriod period,
                                                              FileFormat exportFormat,
                                                              String fileName,
                                                              Long hash) {
        super(hostId, localDateFrom, localDateTo, regionId, regionInclusion, deviceType, exportFormat, fileName, hash);
        this.period = period;
        this.specialGroup = specialGroup;
        this.pathId = pathId;
    }

    public static WorkerTaskData createTaskData(WebmasterHostId hostId,
                                                LocalDate localDateFrom,
                                                LocalDate localDateTo,
                                                Integer[] regionId,
                                                RegionInclusion regionInclusion,
                                                SpecialGroup specialGroup,
                                                PathId pathId,
                                                DeviceType deviceType,
                                                AggregatePeriod period,
                                                FileFormat exportFormat,
                                                String fileName,
                                                Long hash) {
        return new DownloadStatisticSelectedUrlAllIndicatorsTaskData(hostId,
                localDateFrom,
                localDateTo,
                regionId,
                regionInclusion,
                specialGroup,
                pathId,
                deviceType,
                period,
                exportFormat,
                fileName,
                hash);
    }

    public SpecialGroup getSpecialGroup() {
        return specialGroup;
    }

    public PathId getPathId() {
        return pathId;
    }

    public AggregatePeriod getPeriod() {
        return period;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.DOWNLOAD_STATISTIC_SELECTED_URL_ALL_INDICATORS;
    }

    @Override
    public String getShortDescription() {
        return "Download selected url all indicators";
    }
}
