package ru.yandex.webmaster3.storage.download.searchquery;

import org.apache.commons.lang3.StringUtils;
import ru.yandex.webmaster3.core.searchquery.viewer.ViewerQueryGroup;

import java.util.Comparator;
import java.util.List;

/**
 * Created by ifilippov5 on 06.03.17.
 */
public class QueryGroupStatistics {
    private final ViewerQueryGroup group;
    private final QueryIndicatorStatistics indicator;
    private final List<QueryIndicatorStatistics> indicators;

    public QueryGroupStatistics(ViewerQueryGroup group, QueryIndicatorStatistics indicator) {
        this.group = group;
        this.indicator = indicator;
        this.indicators = null;
    }

    public QueryGroupStatistics(ViewerQueryGroup group, List<QueryIndicatorStatistics> indicators) {
        this.group = group;
        this.indicator = null;
        this.indicators = indicators;
    }

    public ViewerQueryGroup getGroup() {
        return group;
    }

    public QueryIndicatorStatistics getIndicator() {
        return indicator;
    }

    public List<QueryIndicatorStatistics> getIndicators() {
        return indicators;
    }

    public static final Comparator<QueryGroupStatistics> BY_NAME =
            Comparator.comparing(g -> StringUtils.defaultString(g.getGroup().getName()));
}
