package ru.yandex.webmaster3.storage.download.urls;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.download.FileFormat;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;
import ru.yandex.webmaster3.storage.download.DownloadTaskData;
import ru.yandex.webmaster3.storage.searchurl.SearchUrlEventFilter;
import ru.yandex.webmaster3.storage.searchurl.download.EventUrlCsvRow;

import java.util.List;
import java.util.UUID;

/**
 * Created by ifilippov5 on 13.02.17.
 */
public class DownloadEventUrlsTaskData extends DownloadTaskData<EventUrlCsvRow> {
    private final List<SearchUrlEventFilter> parameterFilters;

    public DownloadEventUrlsTaskData(
            @JsonProperty("taskId") UUID taskId,
            @JsonProperty("hostId") WebmasterHostId hostId,
            @JsonProperty("parameterFilters") List<SearchUrlEventFilter> parameterFilters,
            @JsonProperty("nodeId") Long nodeId,
            @JsonProperty("exportFormat") FileFormat exportFormat,
            @JsonProperty("fileName") String fileName,
            @JsonProperty("hash") Long hash) {
        super(taskId, hostId, nodeId, exportFormat, fileName, hash, EventUrlCsvRow.class);
        this.parameterFilters = parameterFilters;
    }

    private DownloadEventUrlsTaskData(WebmasterHostId hostId, List<SearchUrlEventFilter> parameterFilters, Long nodeId,
                                      FileFormat exportFormat, String fileName, Long hash) {
        super(hostId, nodeId, exportFormat, fileName, hash, EventUrlCsvRow.class);
        this.parameterFilters = parameterFilters;
    }

    public static WorkerTaskData createTaskData(WebmasterHostId hostId, List<SearchUrlEventFilter> parameterFilters,
                                                Long nodeId, FileFormat exportFormat, String fileName, Long hash) {
        return new DownloadEventUrlsTaskData(hostId, parameterFilters, nodeId, exportFormat, fileName, hash);
    }

    public List<SearchUrlEventFilter> getParameterFilters() {
        return parameterFilters;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.DOWNLOAD_EVENT_URLS;
    }

    @Override
    public String getShortDescription() {
        return "Download events";
    }
}
