package ru.yandex.webmaster3.storage.download.urls;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.download.FileFormat;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;
import ru.yandex.webmaster3.storage.download.DownloadTaskData;
import ru.yandex.webmaster3.storage.searchurl.SearchUrlFilter;
import ru.yandex.webmaster3.storage.searchurl.download.SearchUrlCsvRow;

import java.util.List;
import java.util.UUID;

/**
 * Created by ifilippov5 on 08.02.17.
 */
public class DownloadSearchUrlsTaskData extends DownloadTaskData<SearchUrlCsvRow> {
    private final List<SearchUrlFilter> parameterFilters;

    public DownloadSearchUrlsTaskData(
            @JsonProperty("taskId") UUID taskId,
            @JsonProperty("hostId") WebmasterHostId hostId,
            @JsonProperty("parameterFilters") List<SearchUrlFilter> parameterFilters,
            @JsonProperty("nodeId") Long nodeId,
            @JsonProperty("exportFormat") FileFormat exportFormat,
            @JsonProperty("fileName") String fileName,
            @JsonProperty("hash") Long hash
    ) {
        super(taskId, hostId, nodeId, exportFormat, fileName, hash, SearchUrlCsvRow.class);
        this.parameterFilters = parameterFilters;
    }

    private DownloadSearchUrlsTaskData(WebmasterHostId hostId, List<SearchUrlFilter> parameterFilters, Long nodeId, FileFormat exportFormat, String fileName, Long hash) {
        super(hostId, nodeId, exportFormat, fileName, hash, SearchUrlCsvRow.class);
        this.parameterFilters = parameterFilters;
    }

    public static WorkerTaskData createTaskData(WebmasterHostId hostId, List<SearchUrlFilter> parameterFilters, Long nodeId, FileFormat exportFormat, String fileName, Long hash) {
        return new DownloadSearchUrlsTaskData(hostId, parameterFilters, nodeId, exportFormat, fileName, hash);
    }

    public List<SearchUrlFilter> getParameterFilters() {
        return parameterFilters;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.DOWNLOAD_SEARCH_URLS;
    }

    @Override
    public String getShortDescription() {
        return "Download search urls";
    }
}
