package ru.yandex.webmaster3.storage.events.data;

import java.util.Collections;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.abt.model.ExperimentInfo;

/**
 * @author avhaliullin
 */
public interface ToUserTranslatable<T extends ToUserTranslatable<T>> extends WMCEventContent {
    WebmasterHostId getHostId();

    T withUser(long userId);

    T setExperimentInfo(ExperimentInfo experimentInfo);

    /**
     * Для случая распространения сообщения не на один хост, а на группу (различные турбо-оповещения)
     *
     * @return
     */
    @JsonIgnore
    default List<WebmasterHostId> getHostIds() {
        return Collections.singletonList(getHostId());
    }

}
