package ru.yandex.webmaster3.storage.events.data;

import com.datastax.driver.core.utils.UUIDs;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonAppend;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import ru.yandex.webmaster3.storage.events.utils.BatchIdUtils;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class WMCEvent {
    private final UUID id;
    private final WMCEventType type;
    private final WMCEventContent content;
    private final Long batchId;

    public WMCEvent(UUID id, WMCEventType type, WMCEventContent content, Long batchId) {
        this.id = id;
        this.type = type;
        this.content = content;
        this.batchId = batchId;
    }

    public DateTime getEventTime() {
        return batchId == null ? new DateTime(UUIDs.unixTimestamp(id)) : new DateTime(UUIDs.unixTimestamp(id));
    }

    public UUID getId() {
        return id;
    }

    public WMCEventType getType() {
        return type;
    }

    public WMCEventContent getContent() {
        return content;
    }

    public Long getBatchId() {
        return batchId;
    }

    @Override
    public String toString() {
        return "WMCEvent{" +
                "eventTime=" + getEventTime() +
                ", id=" + String.valueOf(id) +
                ", type=" + type +
                ", content=" + content +
                '}';
    }

    public static WMCEvent create(WMCEventContent content) {
        return new WMCEvent(UUIDs.timeBased(), content.getType(), content, null);
    }
}
