package ru.yandex.webmaster3.storage.events.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.RequiredArgsConstructor;
import lombok.Value;
import org.joda.time.DateTime;

/**
 * ishalaru
 * 09.12.2020
 **/
@Value
@RequiredArgsConstructor
public class WMCEventProblemContainer {
    private static final int TIMEOUT_IN_MINUTES = 10;
    @JsonProperty("eventType")
    WMCEventType eventType;
    @JsonProperty("content")
    String content;
    @JsonProperty("nextProcessedTime")
    DateTime nextProcessedTime;
    @JsonProperty("retriesCount")
    int retriesCount;
    @JsonProperty("observerName")
    String observerName;

    @JsonIgnore
    public WMCEventProblemContainer(WMCEventType eventType, String content, String observerName) {
        this.eventType = eventType;
        this.content = content;
        this.observerName = observerName;
        this.nextProcessedTime = DateTime.now();
        this.retriesCount = 1;
    }


    public WMCEventProblemContainer incrementRetriesCount() {
        return new WMCEventProblemContainer(eventType, content, DateTime.now().plusMinutes(TIMEOUT_IN_MINUTES), retriesCount + 1, observerName);
    }
}
