package ru.yandex.webmaster3.storage.events.data;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;
import ru.yandex.webmaster3.storage.events.data.events.*;

/**
 * @author avhaliullin
 */
public enum WMCEventType implements IntEnum {
    USER_SITEMAP_CHANGE(2, UserSitemapChangeEvent.class),
    RETRANSLATE_TO_USERS(17, RetranslateToUsersEvent.class),
    USER_HOST_MESSAGE(18, UserHostMessageEvent.class),
    VERIFY_HOST(19, VerifyHostEvent.class),
    SYNC_HOST_VERIFICATION_STATE(20, SyncHostVerificationStateEvent.class),
    METRIKA_COUNTER_BINDING(21, MetrikaCounterBindingEvent.class),
    DELEGATION(22, DelegationToUserEvent.class),
    DELEGATION_TO_NOT_USER(23, DelegationToNotUserEvent.class),
    UPDATE_TURBO_PROBLEMS(24, UpdateTurboProblemsEvent.class),
    TURBO_SETTINGS_CHANGE(25, TurboSettingsChangeEvent.class),
    USER_TAKEOUT(26, UserTakeoutEvent.class), // второй контур обработки запроса на выгрузку данных по GDPR
    USER_VERIFIES_HOST(27, UserVerifiesHostEvent.class),
    USER_DOMAIN_MESSAGE(28, UserDomainMessageEvent.class),
    METRIKA_COUNTER_BINDING_STATE_CHANGE(29, MetrikaCounterBindingStateChangeEvent.class),
    ;

    private final int value;
    private final Class<? extends WMCEventContent> contentClass;

    WMCEventType(int value, Class<? extends WMCEventContent> contentClass) {
        this.value = value;
        this.contentClass = contentClass;
    }

    @Override
    public int value() {
        return value;
    }

    public Class<? extends WMCEventContent> getContentClass() {
        return contentClass;
    }

    public static final IntEnumResolver<WMCEventType> R = IntEnumResolver.r(WMCEventType.class);
}
