package ru.yandex.webmaster3.storage.events.data.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.storage.events.data.AbstractWMCEventContent;
import ru.yandex.webmaster3.storage.events.data.WMCEventType;
import ru.yandex.webmaster3.storage.user.message.content.MessageContent;
import ru.yandex.webmaster3.storage.user.notification.NotificationType;

/**
 * Created by ifilippov5 on 20.02.18.
 */
public class DelegationToUserEvent<C extends MessageContent> extends AbstractWMCEventContent {
    private final long userId;
    private final C messageContent;
    private final boolean critical;

    @JsonCreator
    public DelegationToUserEvent(@JsonProperty("userId") long userId,
                                 @JsonProperty("content") C messageContent,
                                 @JsonProperty("critical") boolean critical) {
        super(WMCEventType.DELEGATION);
        this.userId = userId;
        this.messageContent = messageContent;
        this.critical = critical;
    }

    public long getUserId() {
        return userId;
    }

    public C getMessageContent() {
        return messageContent;
    }

    public boolean isCritical() {
        return critical;
    }
}
