package ru.yandex.webmaster3.storage.events.data.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.metrika.counters.CounterRequestTypeEnum;
import ru.yandex.webmaster3.storage.events.data.AbstractWMCEventContent;
import ru.yandex.webmaster3.storage.events.data.WMCEventType;

/**
 * Created by ifilippov5 on 13.02.18.
 */
public class MetrikaCounterBindingEvent extends AbstractWMCEventContent {
    private final CounterRequestTypeEnum metrikaEvent;
    private final String domain;
    private final long initiatorId;
    private final String initiatorLogin;
    private final long counterId;

    @JsonCreator
    public MetrikaCounterBindingEvent(@JsonProperty("metrikaEvent") CounterRequestTypeEnum metrikaEvent,
                                      @JsonProperty("domain") String domain,
                                      @JsonProperty("userId") long initiatorId,
                                      @JsonProperty("userLogin") String initiatorLogin,
                                      @JsonProperty("counterId") long counterId) {
        super(WMCEventType.METRIKA_COUNTER_BINDING);
        this.metrikaEvent= metrikaEvent;
        this.domain = domain;
        this.initiatorId = initiatorId;
        this.initiatorLogin = initiatorLogin;
        this.counterId = counterId;
    }

    public CounterRequestTypeEnum getMetrikaEvent() {
        return metrikaEvent;
    }

    public String getDomain() {
        return domain;
    }

    public long getInitiatorId() {
        return initiatorId;
    }

    public String getInitiatorLogin() {
        return initiatorLogin;
    }

    public long getCounterId() {
        return counterId;
    }
}
