package ru.yandex.webmaster3.storage.events.data.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import ru.yandex.webmaster3.core.metrika.counters.CounterBindingStateEnum;
import ru.yandex.webmaster3.core.metrika.counters.CounterRequestTypeEnum;
import ru.yandex.webmaster3.storage.events.data.AbstractWMCEventContent;
import ru.yandex.webmaster3.storage.events.data.WMCEventType;

/**
 * @author leonidrom
 */
@Getter
public class MetrikaCounterBindingStateChangeEvent extends AbstractWMCEventContent {
    private final CounterRequestTypeEnum metrikaEvent;
    private final String domain;
    private final long initiatorId;
    private final String initiatorLogin;
    private final long counterId;
    private final CounterBindingStateEnum prevState;
    private final CounterBindingStateEnum state;

    @JsonCreator
    public MetrikaCounterBindingStateChangeEvent(
            @JsonProperty("metrikaEvent") CounterRequestTypeEnum metrikaEvent,
            @JsonProperty("domain") String domain,
            @JsonProperty("userId") long initiatorId,
            @JsonProperty("userLogin") String initiatorLogin,
            @JsonProperty("counterId") long counterId,
            @JsonProperty("prevState") CounterBindingStateEnum prevState,
            @JsonProperty("state") CounterBindingStateEnum state) {
        super(WMCEventType.METRIKA_COUNTER_BINDING_STATE_CHANGE);

        this.metrikaEvent = metrikaEvent;
        this.domain = domain;
        this.initiatorId = initiatorId;
        this.initiatorLogin = initiatorLogin;
        this.counterId = counterId;
        this.prevState = prevState;
        this.state = state;
    }
}
