package ru.yandex.webmaster3.storage.events.data.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;
import ru.yandex.webmaster3.storage.abt.model.Experiment;
import ru.yandex.webmaster3.storage.events.data.AbstractWMCEventContent;
import ru.yandex.webmaster3.storage.events.data.ToUserTranslatable;
import ru.yandex.webmaster3.storage.events.data.WMCEventType;

import java.util.Collections;
import java.util.List;

/**
 * @author avhaliullin
 */
public class RetranslateToUsersEvent<P extends ToUserTranslatable<P>> extends AbstractWMCEventContent {
    private final P payload;
    private final WMCEventType payloadType;
    private final List<Long> excludedUsers;

    // Эксперимент, в рамках которого надо рассылать сообщения
    @Nullable
    private final Experiment experiment;

    public RetranslateToUsersEvent(P payload) {
        this(payload, Collections.emptyList());
    }

    public RetranslateToUsersEvent(@JsonProperty("payload") P payload,
                                   @JsonProperty("excludedUsers") List<Long> excludedUsers) {
        this(payload, excludedUsers, null);
    }

    @JsonCreator
    public RetranslateToUsersEvent(@JsonProperty("payload") P payload,
                                   @JsonProperty("excludedUsers") List<Long> excludedUsers,
                                   @JsonProperty("experiment") Experiment experiment) {
        super(WMCEventType.RETRANSLATE_TO_USERS);
        this.payload = payload;
        this.payloadType = payload.getType();
        this.excludedUsers = excludedUsers;
        this.experiment = experiment;
    }

    public WMCEventType getPayloadType() {
        return payloadType;
    }

    public P getPayload() {
        return payload;
    }

    public List<Long> getExcludedUsers() {
        if (excludedUsers == null) {
            return Collections.emptyList();
        }
        return excludedUsers;
    }

    @Nullable
    public Experiment getExperiment() {
        return experiment;
    }
}
