package ru.yandex.webmaster3.storage.events.data.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.events.data.AbstractWMCEventContent;
import ru.yandex.webmaster3.storage.events.data.WMCEventType;

/**
 * @author avhaliullin
 */
public class SyncHostVerificationStateEvent extends AbstractWMCEventContent {
    private final WebmasterHostId hostId;
    private final long userId;

    public SyncHostVerificationStateEvent(
            @JsonProperty("hostId") WebmasterHostId hostId,
            @JsonProperty("userId") long userId) {
        super(WMCEventType.SYNC_HOST_VERIFICATION_STATE);
        this.hostId = hostId;
        this.userId = userId;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public long getUserId() {
        return userId;
    }

}
