package ru.yandex.webmaster3.storage.events.data.events;

import java.util.List;
import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.log.LogfellerEvent;
import ru.yandex.webmaster3.core.turbo.model.TurboHostSettings;
import ru.yandex.webmaster3.core.turbo.model.app.TurboAppSettings;
import ru.yandex.webmaster3.core.turbo.model.autoparser.AutoparserToggleState;
import ru.yandex.webmaster3.core.turbo.model.commerce.TurboPlusSettings;
import ru.yandex.webmaster3.core.turbo.model.desktop.TurboDesktopSettings;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedSettings;
import ru.yandex.webmaster3.storage.events.data.AbstractWMCEventContent;
import ru.yandex.webmaster3.storage.events.data.WMCEventType;

/**
 * Created by Oleg Bazdyrev on 07/02/2019.
 * Эвент для передачи в логброкер фактов изменения настроек турбо
 */
@Getter
public class TurboSettingsChangeEvent extends AbstractWMCEventContent {
    private final String domain;
    private final TurboHostSettings turboHostSettings;
    private final TurboDesktopSettings turboDesktopSettings;
    private final TurboAppSettings turboAppSettings;
    private final TurboPlusSettings turboPlusSettings;
    private final AutoparserToggleState autoparserToggleState;
    private final List<TurboFeedSettings> feedSettingsList;

    @JsonCreator
    public TurboSettingsChangeEvent(@JsonProperty("domain") String domain,
                                    @JsonProperty("turboHostSettings") TurboHostSettings turboHostSettings,
                                    @JsonProperty("turboDesktopSettings") TurboDesktopSettings turboDesktopSettings,
                                    @JsonProperty("turboAppSettings") TurboAppSettings turboAppSettings,
                                    @JsonProperty("turboPlusSettings") TurboPlusSettings turboPlusSettings,
                                    @JsonProperty("autoparserToggleState") AutoparserToggleState autoparserToggleState,
                                    @JsonProperty("feedSettingsList") List<TurboFeedSettings> feedSettingsList) {
        super(WMCEventType.TURBO_SETTINGS_CHANGE);
        this.domain = domain;
        this.turboHostSettings = turboHostSettings;
        this.turboDesktopSettings = turboDesktopSettings;
        this.turboAppSettings = turboAppSettings;
        this.turboPlusSettings = turboPlusSettings;
        this.autoparserToggleState = autoparserToggleState;
        this.feedSettingsList = feedSettingsList;
    }

    public LogfellerEvent convert() {
        return new LogfellerEvent(
                "TURBO_SETTINGS_CHANGE",
                UUID.randomUUID(), this, DateTime.now(), "turboSettingsChange", DateTime.now());
    }

}
