package ru.yandex.webmaster3.storage.events.data.events;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.abt.model.ExperimentInfo;
import ru.yandex.webmaster3.storage.events.data.WMCEventType;
import ru.yandex.webmaster3.storage.user.message.content.MessageContent;
import ru.yandex.webmaster3.storage.user.notification.NotificationType;

/**
 * Расширение класса для оповещения по домену
 */
public class UserDomainMessageEvent<C extends MessageContent> extends UserHostMessageEvent<C> {

    @JsonCreator
    private UserDomainMessageEvent(@JsonProperty("hostId") WebmasterHostId hostId,
                                   @JsonProperty("userId") Long userId,
                                   @JsonProperty("content") C messageContent,
                                   @JsonProperty("notificationType") NotificationType notificationType,
                                   @JsonProperty("critical") boolean critical,
                                   @JsonProperty("experimentInfo") ExperimentInfo experimentInfo) {
        super(hostId, userId, messageContent, notificationType, critical, experimentInfo);
    }

    @Override
    public WMCEventType getType() {
        return WMCEventType.USER_DOMAIN_MESSAGE;
    }

    public static <C extends MessageContent> UserDomainMessageEvent<C> create(WebmasterHostId hostId, C content,
                                                                              NotificationType notificationType,
                                                                              boolean critical) {
        return new UserDomainMessageEvent<>(hostId, null, content, notificationType, critical, null);
    }

    @Override
    public UserDomainMessageEvent<C> withUser(long userId) {
        return new UserDomainMessageEvent<>(hostId, userId, messageContent, notificationType, critical, experimentInfo);
    }

    @Override
    public List<WebmasterHostId> getHostIds() {
        return WwwUtil.domainToHostIds(WwwUtil.cutWWWAndM(hostId));
    }
}
