package ru.yandex.webmaster3.storage.events.data.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.abt.model.ExperimentInfo;
import ru.yandex.webmaster3.storage.events.data.AbstractWMCEventContent;
import ru.yandex.webmaster3.storage.events.data.ToUserTranslatable;
import ru.yandex.webmaster3.storage.events.data.WMCEventType;
import ru.yandex.webmaster3.storage.user.message.content.MessageContent;
import ru.yandex.webmaster3.storage.user.notification.NotificationType;

/**
 * @author avhaliullin
 */
public class UserHostMessageEvent<C extends MessageContent> extends AbstractWMCEventContent implements ToUserTranslatable<UserHostMessageEvent<C>> {
    protected final WebmasterHostId hostId;
    protected final Long userId;
    protected final C messageContent;
    protected final NotificationType notificationType;
    protected final boolean critical;
    protected ExperimentInfo experimentInfo;

    @JsonCreator
    public UserHostMessageEvent(
            @JsonProperty("hostId") WebmasterHostId hostId,
            @JsonProperty("userId") Long userId,
            @JsonProperty("content") C messageContent,
            @JsonProperty("notificationType") NotificationType notificationType,
            @JsonProperty("critical") boolean critical,
            @JsonProperty("experimentInfo") ExperimentInfo experimentInfo) {
        super(WMCEventType.USER_HOST_MESSAGE);
        this.hostId = hostId;
        this.userId = userId;
        this.messageContent = messageContent;
        this.notificationType = notificationType;
        this.critical = critical;
        this.experimentInfo = experimentInfo;
    }

    public UserHostMessageEvent(
            @JsonProperty("hostId") WebmasterHostId hostId,
            @JsonProperty("userId") Long userId,
            @JsonProperty("content") C messageContent,
            @JsonProperty("notificationType") NotificationType notificationType,
            @JsonProperty("critical") boolean critical) {
        super(WMCEventType.USER_HOST_MESSAGE);
        this.hostId = hostId;
        this.userId = userId;
        this.messageContent = messageContent;
        this.notificationType = notificationType;
        this.critical = critical;
        this.experimentInfo = null;
    }


    @Override
    public UserHostMessageEvent<C> withUser(long userId) {
        return new UserHostMessageEvent<>(hostId, userId, messageContent, notificationType, critical, experimentInfo);
    }

    public UserHostMessageEvent<C> setExperimentInfo(ExperimentInfo experimentInfo) {
        this.experimentInfo = experimentInfo;
        return this;
    }

    @Override
    public WebmasterHostId getHostId() {
        return hostId;
    }

    public Long getUserId() {
        return userId;
    }

    public C getMessageContent() {
        return messageContent;
    }

    public ExperimentInfo getExperimentInfo() {
        return experimentInfo;
    }

    public NotificationType getNotificationType() {
        return notificationType;
    }

    public boolean isCritical() {
        return critical;
    }

    public static <C extends MessageContent> UserHostMessageEvent<C> create(WebmasterHostId hostId, C content,
                                                                            NotificationType notificationType, boolean critical) {
        return new UserHostMessageEvent<>(hostId, null, content, notificationType, critical, null);
    }
}
