package ru.yandex.webmaster3.storage.events.data.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.events.data.AbstractWMCEventContent;
import ru.yandex.webmaster3.storage.events.data.WMCEventType;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class UserSitemapChangeEvent extends AbstractWMCEventContent {
    private final WebmasterHostId hostId;
    private final UUID sitemapId;

    public UserSitemapChangeEvent(@JsonProperty("hostId") WebmasterHostId hostId, @JsonProperty("sitemapId") UUID sitemapId) {
        super(WMCEventType.USER_SITEMAP_CHANGE);
        this.hostId = hostId;
        this.sitemapId = sitemapId;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public UUID getSitemapId() {
        return sitemapId;
    }
}
