package ru.yandex.webmaster3.storage.events.data.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.storage.events.data.AbstractWMCEventContent;
import ru.yandex.webmaster3.storage.events.data.WMCEventType;

import java.util.UUID;

/**
 * @author leonidrom
 *
 * Событие для обработки запроса на пользовательскую выгрузку по GDPR.
 * Используется как дополнительная мера надежности на случай, если
 * воркерная таска не сможет по каким то причинам обработать запрос.
 */
public class UserTakeoutEvent extends AbstractWMCEventContent {
    private final long userId;
    private final UUID requestId;

    /**
     * @param userId пользователь, для которого надо сделать выгрузку
     * @param requestId уникальный id запроса на выгрузку
     */
    public UserTakeoutEvent(@JsonProperty("userId") long userId, @JsonProperty("requestId") UUID requestId) {
        super(WMCEventType.USER_TAKEOUT);
        this.userId = userId;
        this.requestId = requestId;
    }

    public long getUserId() {
        return userId;
    }

    public UUID getRequestId() {
        return requestId;
    }
}
