package ru.yandex.webmaster3.storage.events.data.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.events.data.AbstractWMCEventContent;
import ru.yandex.webmaster3.storage.events.data.WMCEventType;

/**
 * @author akhazhoyan 02/2019
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class UserVerifiesHostEvent extends AbstractWMCEventContent {
    private final long userId;
    private final WebmasterHostId hostId;
    private final boolean isNewHost;

    @JsonCreator
    public UserVerifiesHostEvent(
            @JsonProperty("userId") long userId,
            @JsonProperty("hostId") WebmasterHostId hostId,
            @JsonProperty("isNewHost") boolean isNewHost) {
        super(WMCEventType.USER_VERIFIES_HOST);
        this.userId = userId;
        this.hostId = hostId;
        this.isNewHost = isNewHost;
    }

    public long getUserId() {
        return userId;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public boolean isNewHost() {
        return isNewHost;
    }
}
