package ru.yandex.webmaster3.storage.events.data.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.host.verification.VerificationType;
import ru.yandex.webmaster3.storage.events.data.AbstractWMCEventContent;
import ru.yandex.webmaster3.storage.events.data.WMCEventType;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class VerifyHostEvent extends AbstractWMCEventContent {
    private final WebmasterHostId hostId;
    private final long userId;
    private final UUID recordId;
    private final VerificationType verificationType;

    public VerifyHostEvent(
            @JsonProperty("hostId") WebmasterHostId hostId,
            @JsonProperty("userId") long userId,
            @JsonProperty("recordId") UUID recordId,
            @JsonProperty("verificationType") VerificationType verificationType) {
        super(WMCEventType.VERIFY_HOST);
        this.hostId = hostId;
        this.userId = userId;
        this.recordId = recordId;
        this.verificationType = verificationType;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public long getUserId() {
        return userId;
    }

    public UUID getRecordId() {
        return recordId;
    }

    public VerificationType getVerificationType() {
        return verificationType;
    }
}
