package ru.yandex.webmaster3.storage.events.service;

import ru.yandex.webmaster3.storage.events.data.WMCEvent;

/**
 * @author avhaliullin
 */
public interface WMCEventsObserver {
    /**
     * @return true, если событие было каким то осмысленным образом обработано клиентом
     * и этот факт нужно сохранить в LB. Используется только для логгирования, которое
     * по умолчанию не делается, поэтому если логгирование не нужно, можно возвращать
     * любое значение.
     */
    boolean observe(WMCEvent event);

    /**
     * @return true, если обработанные сообщения нужно логгировать в LB
     */
    default boolean isProcessedLoggingEnabled() {
        return false;
    }
}
