package ru.yandex.webmaster3.storage.events.service;

import java.util.List;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.storage.events.data.WMCEvent;
import ru.yandex.webmaster3.storage.events.data.WMCEventContent;

/**
 * @author avhaliullin
 */
@Service("wmcEventsService")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class WMCEventsService {
    private final LbWMCEventService lbWmcEventService;

    public void addEvent(WMCEventContent event) {
        lbWmcEventService.send(List.of(event));
    }

    public void addEvent(WMCEvent event) {
        lbWmcEventService.send(List.of(event.getContent()));
    }

    public void addEventContents(List<WMCEventContent> events) {
        lbWmcEventService.send(events);
    }

    public void addEvents(List<WMCEvent> events) {
        lbWmcEventService.sendWmcEvent(events);
    }
}
