package ru.yandex.webmaster3.storage.events2;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

import lombok.Setter;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.events2.HostEvent;
import ru.yandex.webmaster3.core.events2.HostEventJsonUtils;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseException;
import ru.yandex.webmaster3.storage.util.fs.persistence.CHBatchWriter;

/**
 * @author avhaliullin
 */
public class HostEventLogBatchWriter extends CHBatchWriter<HostEvent> {
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    @Setter
    private HostEventsCHDao mdbHostEventsCHDao;

    public HostEventLogBatchWriter() {
        super(3, 400_000);
    }

    @Override
    public void logSyncInternal(List<HostEvent> items) {
        try {
            mdbHostEventsCHDao.insertEvents(items);
        } catch (ClickhouseException e) {
            throw new WebmasterException("Failed to write host events",
                    new WebmasterErrorResponse.ClickhouseErrorResponse(getClass(), null, e), e);
        }
    }

    @Override
    protected byte[] serialize(HostEvent entity) {
        return HostEventJsonUtils.serializeEvent(entity).getBytes(CHARSET);
    }

    @Override
    protected HostEvent deserialize(byte[] data, int offset, int len) {
        return HostEventJsonUtils.deserializeEvent(new String(data, offset, len, CHARSET));
    }
}
