package ru.yandex.webmaster3.storage.events2;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.events2.HostEvent;
import ru.yandex.webmaster3.core.events2.client.HostEventLogClient;

/**
 * @author avhaliullin
 */
public class LocalHostEventLogClient implements HostEventLogClient {
    private HostEventLogBatchWriter hostEventLogBatchWriter;

    @Override
    public void log(HostEvent event) {
        hostEventLogBatchWriter.write(event);
    }

    @Required
    public void setHostEventLogBatchWriter(HostEventLogBatchWriter hostEventLogBatchWriter) {
        this.hostEventLogBatchWriter = hostEventLogBatchWriter;
    }
}
