package ru.yandex.webmaster3.storage.favicon;

import java.util.Comparator;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.AllArgsConstructor;
import lombok.Value;
import org.apache.commons.lang3.ObjectUtils;

import ru.yandex.webmaster3.proto.Favicons;

/**
 * Created by Oleg Bazdyrev on 03/08/2020.
 */
@Value
@AllArgsConstructor(onConstructor_ = {@JsonCreator})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class FaviconInfo {

    public static final TypeReference<List<FaviconInfo>> LIST_REFERENCE = new TypeReference<>() {
    };

    String url;
    int httpCode;
    boolean isFromMorda;
    boolean isOnSearch;
    long lastAccess;
    int mimeType;
    String redirTarget;
    int targetSize;
    Integer height;
    Integer width;

    public static FaviconInfo fromProto(Favicons.TFaviconSample sample) {
        return new FaviconInfo(
                sample.getUrl(),
                sample.getHttpCode(),
                sample.getIsFromMorda(),
                sample.getIsOnSearch(),
                sample.getLastAccess(),
                sample.getMimeType(),
                sample.getRedirTarget(),
                sample.getTargetSize(),
                sample.getHeight(),
                sample.getWidth()
        );
    }

    public static Comparator<FaviconInfo> BY_SIZE = Comparator.<FaviconInfo, Integer>comparing(f -> ObjectUtils.max(f.getHeight(), f.getWidth(), 0))
            .thenComparing(FaviconInfo::isOnSearch);
}
