package ru.yandex.webmaster3.storage.feedback.service;

import lombok.RequiredArgsConstructor;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.yandex.webmaster3.core.data.WebmasterUser;
import ru.yandex.webmaster3.storage.feedback.dao.FeedbackYDao;
import ru.yandex.webmaster3.storage.user.UserTakeoutDataProvider;

import java.util.List;

/**
 * @author leonidrom
 */
@Service
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class FeedbackService implements UserTakeoutDataProvider {
    private final FeedbackYDao feedbackYDao;

    @Override
    public void deleteUserData(WebmasterUser user) {
        feedbackYDao.deleteForUser(user.getUserId());
    }

    @Override
    public @NotNull List<String> getTakeoutTables() {
        return List.of(
                feedbackYDao.getTablePath()
        );
    }
}


