package ru.yandex.webmaster3.storage.feeds.download;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;

import ru.yandex.webmaster3.core.feeds.feed.NativeFeedType;
import ru.yandex.webmaster3.storage.download.common.DownloadFileType;
import ru.yandex.webmaster3.storage.download.common.MdsExportDescriptor;

/**
 * Created by Oleg Bazdyrev on 18/01/2022.
 */
public class FeedsAllErrorsMdsExportDescriptor extends MdsExportDescriptor {

    @Getter
    private final long userId;
    @Getter
    private final String domain;
    @Getter
    private final NativeFeedType feedType;

    @JsonCreator
    public FeedsAllErrorsMdsExportDescriptor(@JsonProperty("userId") long userId,
                                             @JsonProperty("domain") String domain,
                                             @JsonProperty("feedType") NativeFeedType feedType) {
        super(DownloadFileType.FEEDS_ALL_ERRORS);
        this.userId = userId;
        this.domain = domain;
        this.feedType = feedType;
    }

}
