package ru.yandex.webmaster3.storage.feeds.download;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import org.joda.time.LocalDate;

import ru.yandex.webmaster3.core.feeds.feed.NativeFeedType;
import ru.yandex.webmaster3.storage.download.common.DownloadFileType;
import ru.yandex.webmaster3.storage.download.common.MdsExportDescriptor;

/**
 * Created by Oleg Bazdyrev on 14/03/2022.
 */
public abstract class FeedsClickStatisticsMdsExportDescriptor extends MdsExportDescriptor {

    @Getter
    private final String domain;
    @Getter
    private final NativeFeedType feedType;
    @Getter
    private final LocalDate from;
    @Getter
    private final LocalDate to;

    @JsonCreator
    public FeedsClickStatisticsMdsExportDescriptor(DownloadFileType type, String domain, NativeFeedType feedType, LocalDate from, LocalDate to) {
        super(type);
        this.domain = domain;
        this.feedType = feedType;
        this.from = from;
        this.to = to;
    }

    public static final class FeedsSetClickStatisticsMdsExportDescriptor extends FeedsClickStatisticsMdsExportDescriptor {

        @JsonCreator
        public FeedsSetClickStatisticsMdsExportDescriptor(@JsonProperty("domain") String domain,
                                                          @JsonProperty("feedType") NativeFeedType feedType,
                                                          @JsonProperty("from") LocalDate from,
                                                          @JsonProperty("to") LocalDate to) {
            super(DownloadFileType.FEEDS_SET_CLICK_STATISTICS, domain, feedType, from, to);
        }
    }

    public static final class FeedsOfferClickStatisticsMdsExportDescriptor extends FeedsClickStatisticsMdsExportDescriptor {

        @JsonCreator
        public FeedsOfferClickStatisticsMdsExportDescriptor(@JsonProperty("domain") String domain,
                                                            @JsonProperty("feedType") NativeFeedType feedType,
                                                            @JsonProperty("from") LocalDate from,
                                                            @JsonProperty("to") LocalDate to) {
            super(DownloadFileType.FEEDS_OFFER_CLICK_STATISTICS, domain, feedType, from, to);
        }
    }
}
