package ru.yandex.webmaster3.storage.feeds.download;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;

import ru.yandex.webmaster3.storage.download.common.DownloadFileType;
import ru.yandex.webmaster3.storage.download.common.MdsExportDescriptor;

/**
 * Created by Oleg Bazdyrev on 18/01/2022.
 */
public abstract class FeedsErrorsMdsExportDescriptor extends MdsExportDescriptor {

    @Getter
    private final long userId;
    @Getter
    private final String domain;
    @Getter
    private final String feed;
    @Getter
    private final long timestamp;

    @JsonCreator
    public FeedsErrorsMdsExportDescriptor(@JsonProperty("type") DownloadFileType type,
                                          @JsonProperty("userId") long userId,
                                          @JsonProperty("domain") String domain,
                                          @JsonProperty("feed") String feed,
                                          @JsonProperty("timestamp") long timestamp) {
        super(type);
        this.userId = userId;
        this.domain = domain;
        this.feed = feed;
        this.timestamp = timestamp;
    }

    public static final class FeedsValidationErrorsMdsExportDescriptor extends FeedsErrorsMdsExportDescriptor {

        @JsonCreator
        public FeedsValidationErrorsMdsExportDescriptor(@JsonProperty("userId") long userId,
                                                        @JsonProperty("domain") String domain,
                                                        @JsonProperty("feed") String feed,
                                                        @JsonProperty("timestamp") long timestamp) {
            super(DownloadFileType.FEEDS_VALIDATION_ERRORS, userId, domain, feed, timestamp);
        }
    }

    public static final class FeedsQualityErrorsMdsExportDescriptor extends FeedsErrorsMdsExportDescriptor {

        @JsonCreator
        public FeedsQualityErrorsMdsExportDescriptor(@JsonProperty("userId") long userId,
                                                     @JsonProperty("domain") String domain,
                                                     @JsonProperty("feed") String feed,
                                                     @JsonProperty("timestamp") long timestamp) {
            super(DownloadFileType.FEEDS_QUALITY_ERRORS, userId, domain, feed, timestamp);
        }
    }

    public static final class FeedsDomainErrorsMdsExportDescriptor extends FeedsErrorsMdsExportDescriptor {

        @JsonCreator
        public FeedsDomainErrorsMdsExportDescriptor(@JsonProperty("userId") long userId,
                                                    @JsonProperty("domain") String domain,
                                                    @JsonProperty("timestamp") long timestamp) {
            super(DownloadFileType.FEEDS_DOMAIN_ERRORS, userId, domain, "", timestamp);
        }
    }
}
