package ru.yandex.webmaster3.storage.feeds.download;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import org.joda.time.LocalDate;

import ru.yandex.webmaster3.core.feeds.feed.NativeFeedType;
import ru.yandex.webmaster3.storage.download.common.DownloadFileType;
import ru.yandex.webmaster3.storage.download.common.MdsExportDescriptor;

/**
 * Created by Oleg Bazdyrev on 31/03/2022.
 */

public class FeedsNotEnrichableShowsMdsExportDescriptor extends MdsExportDescriptor {

    @Getter
    private final String domain;
    @Getter
    private final NativeFeedType feedType;
    @Getter
    private final LocalDate from;
    @Getter
    private final LocalDate to;

    public FeedsNotEnrichableShowsMdsExportDescriptor(@JsonProperty("domain") String domain,
                                                      @JsonProperty("feedType") NativeFeedType feedType,
                                                      @JsonProperty("from") LocalDate from,
                                                      @JsonProperty("to") LocalDate to) {
        super(DownloadFileType.FEEDS_NOT_ENRICHABLE_SHOWS);
        this.domain = domain;
        this.feedType = feedType;
        this.from = from;
        this.to = to;
    }
}
