package ru.yandex.webmaster3.storage.feeds.download;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;

import ru.yandex.webmaster3.core.feeds.feed.NativeFeedType;
import ru.yandex.webmaster3.storage.download.common.DownloadFileType;
import ru.yandex.webmaster3.storage.download.common.MdsExportDescriptor;

public class FeedsOfferBansDescriptor extends MdsExportDescriptor {

    @Getter
    private final String domain;
    @Getter
    private final NativeFeedType feedType;

    @JsonCreator
    public FeedsOfferBansDescriptor(@JsonProperty("domain") String domain,
                                    @JsonProperty("feedType") NativeFeedType feedType) {
        super(DownloadFileType.FEEDS_OFFER_BAN);
        this.domain = domain;
        this.feedType = feedType;
    }
}
