package ru.yandex.webmaster3.storage.feeds.models;

import lombok.Value;
import org.joda.time.LocalDate;

import ru.yandex.webmaster3.core.feeds.feed.NativeFeedType;

/**
 * Created by Oleg Bazdyrev on 04/04/2022.
 */
@Value
public class DomainOffersStatistics {
    LocalDate date;
    String domain;
    NativeFeedType type;
    Long offers;
    Long sets;

    public static DomainOffersStatistics create(LocalDate date, String domain, String type, Long offers, Long sets) {
        return new DomainOffersStatistics(date, domain, NativeFeedType.valueOf(type), offers, sets);
    }
}
