package ru.yandex.webmaster3.storage.feeds.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Value;
import org.jetbrains.annotations.NotNull;

import ru.yandex.webmaster3.core.feeds.feed.NativeFeedStatus;
import ru.yandex.webmaster3.storage.feeds.logs.FeedsOffersLogsHistoryCHDao;

/**
 * Created by Oleg Bazdyrev on 26/04/2022.
 */
@Value
@JsonIgnoreProperties(ignoreUnknown = true)
@AllArgsConstructor(onConstructor_ = @JsonCreator)
public class FeedStats {
    public static final FeedStats EMPTY = new FeedStats(0L, 0L, 0L, 0L);

    long error;
    long info;
    long warning;
    long ok;

    @JsonIgnore
    public long getTotal() {
        return error + info + warning + ok;
    }

    @NotNull
    public static NativeFeedStatus calcFeedStatus(FeedStats offerStats, FeedStats errorStats, FeedStats serpdataStats) {
        NativeFeedStatus status;
        if (offerStats == FeedStats.EMPTY) {
            status = NativeFeedStatus.IN_PROGRESS;
        } else if (offerStats.getOk() == 0 && errorStats.getError() > 0) {
            status = NativeFeedStatus.FAILED;
        } else if (errorStats.getError() > 0 || errorStats.getWarning() > 0 || serpdataStats.getError() > 0 || serpdataStats.getWarning() > 0) {
            status = NativeFeedStatus.WARNING;
        } else {
            status = NativeFeedStatus.SUCCESS;
        }
        return status;
    }
}
