package ru.yandex.webmaster3.storage.feeds.models;

import lombok.Value;
import org.joda.time.LocalDate;

import ru.yandex.webmaster3.core.feeds.feed.NativeFeedType;

/**
 * Created by Oleg Bazdyrev on 04/04/2022.
 */
@Value
public class FeedsOffersStatistics {
    LocalDate date;
    String domain;
    String feed;
    NativeFeedType type;
    String state;
    long offers;
    long sets;

    public static FeedsOffersStatistics create(LocalDate date, String domain, String feed, String type, String state, Long offers, Long sets) {
        return new FeedsOffersStatistics(date, domain, feed, NativeFeedType.OFFER_BASE_TYPE_TO_ENUM.get(type), state, offers, sets);
    }

    public static FeedsOffersStatistics create(LocalDate date, String feed, String type, String state, Long offers, Long sets) {
        return new FeedsOffersStatistics(date, null, feed, NativeFeedType.OFFER_BASE_TYPE_TO_ENUM.get(type), state, offers, sets);
    }
}
