package ru.yandex.webmaster3.storage.feeds.models;

import java.util.List;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.feeds.feed.FeedServiceType;
import ru.yandex.webmaster3.core.feeds.feed.NativeFeedType;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.storage.async.model.IRequestData;

/**
 * @author: kravchenko99
 * DATE: 19.11.2021
 * Pojo class for save data in storage
 */
@Getter
@AllArgsConstructor
@Setter(onMethod_ = @RequestQueryProperty)
public class ProcessingAddFeedInputData implements IRequestData {
    WebmasterHostId hostId;
    String url;
    List<Integer> regionsId;
    long userId;
    NativeFeedType type;
    Set<FeedServiceType> enabledServiceTypes;
    String login;
    String password;

    @JsonCreator
    public ProcessingAddFeedInputData(String hostId, String url, List<Integer> regionsId, long userId,
                                      NativeFeedType type, Set<FeedServiceType> enabledServiceTypes, String login,
                                      String password) {
        this.hostId = IdUtils.stringToHostId(hostId);
        this.url = url;
        this.regionsId = regionsId;
        this.userId = userId;
        this.type = type;
        this.enabledServiceTypes = enabledServiceTypes;
        this.login = login;
        this.password = password;
    }

    public String getHostId() {
        return hostId.toStringId();
    }

    @JsonIgnore
    public WebmasterHostId getHId() {
        return hostId;
    }
}
