package ru.yandex.webmaster3.storage.feeds.statistics;

import java.util.List;

import org.joda.time.LocalDate;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.feeds.models.DomainOffersStatistics;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * Created by Oleg Bazdyrev on 21/01/2022.
 */
@Repository
public class DomainOffersStatisticsYDao extends AbstractYDao {

    private static final DataMapper<DomainOffersStatistics> MAPPER = DataMapper.create(F.DATE, F.DOMAIN, F.TYPE, F.OFFERS, F.SETS,
            DomainOffersStatistics::create);

    protected DomainOffersStatisticsYDao() {
        super(PREFIX_FEEDS, "domain_offers_statistics");
    }

    public List<DomainOffersStatistics> getStatistics(LocalDate date, String domain) {
        return select(MAPPER).where(F.DATE.eq(date)).and(F.DOMAIN.eq(domain)).queryForList();
    }

    private interface F {
        Field<LocalDate> DATE = Fields.jodaDateField("date");
        Field<String> DOMAIN = Fields.stringField("domain");
        Field<String> TYPE = Fields.stringField("type").makeOptional();
        Field<Long> OFFERS = Fields.longField("offers");
        Field<Long> SETS = Fields.longField("sets");
    }
}
