package ru.yandex.webmaster3.storage.feeds.statistics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.google.common.collect.Lists;
import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.LocalDate;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.feeds.models.FeedsOffersStatistics;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.ValueDataMapper;

/**
 * Created by Oleg Bazdyrev on 21/01/2022.
 */
@Repository
public class FeedsOffersStatisticsYDao extends AbstractYDao {

    private static final DataMapper<FeedsOffersStatistics> MAPPER = DataMapper.create(F.DATE, F.FEED, F.TYPE, F.STATE, F.OFFERS, F.SETS,
            FeedsOffersStatistics::create);

    private static final ValueDataMapper<FeedsOffersStatistics> VALUE_DATA_MAPPER = ValueDataMapper.create2(
            Pair.of(F.DATE, FeedsOffersStatistics::getDate),
            Pair.of(F.FEED, FeedsOffersStatistics::getFeed),
            Pair.of(F.TYPE, FeedsOffersStatistics::getType),
            Pair.of(F.STATE, FeedsOffersStatistics::getState),
            Pair.of(F.OFFERS, FeedsOffersStatistics::getOffers),
            Pair.of(F.SETS, FeedsOffersStatistics::getSets)
    );

    public void insertBatch(Collection<FeedsOffersStatistics> batch) {
        batchInsert(VALUE_DATA_MAPPER, batch).execute();
    }

    protected FeedsOffersStatisticsYDao() {
        super(PREFIX_FEEDS, "feeds_offers_statistics3");
    }

    public List<FeedsOffersStatistics> getStatistics(LocalDate date, List<String> feeds) {
        List<FeedsOffersStatistics> result = new ArrayList<>();
        for (var batch : Lists.partition(feeds, 1000)) {
            result.addAll(select(MAPPER).where(F.DATE.eq(date)).and(F.FEED.in(batch)).queryForList());
        }
        return result;
    }

    private interface F {
        Field<LocalDate> DATE = Fields.jodaDateField("date");
        Field<String> FEED = Fields.stringField("feed");
        Field<String> TYPE = Fields.stringField("type").makeOptional();
        Field<String> STATE = Fields.stringField("state").makeOptional();
        Field<Long> OFFERS = Fields.longField("offers");
        Field<Long> SETS = Fields.longField("sets");
    }
}
