package ru.yandex.webmaster3.storage.feeds.statistics;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

import lombok.Value;
import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.LocalDate;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.query.Clause;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.FieldMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * Created by Oleg Bazdyrev on 21/01/2022.
 */
@Repository
public class MarketOffersStatisticsYDao extends AbstractYDao {

    protected MarketOffersStatisticsYDao() {
        super(PREFIX_FEEDS, "market_offers_statistics");
    }

    public List<MarketOffersStatistics> getStatistics(LocalDate date, Collection<Pair<Long, Long>> partnerIds) {
        if (partnerIds.isEmpty()) {
            return Collections.emptyList();
        }
        return select(MAPPER).where(F.DATE.eq(date)).and(new Clause.InClause(
                "(" + F.BUSINESS_ID.getName() + "," + F.PARTNER_ID.getName() + ")", partnerIds)).queryForList(
                FieldMapper.create(F.DATE, MarketOffersStatistics::getDate),
                FieldMapper.create(F.BUSINESS_ID, MarketOffersStatistics::getBusinessId),
                FieldMapper.create(F.PARTNER_ID, MarketOffersStatistics::getPartnerId)
        );
    }

    @Value
    public static class MarketOffersStatistics {
        LocalDate date;
        long businessId;
        long partnerId;
        Long feedId;
        long offers;
        long robotOffers;

    }

    private static final DataMapper<MarketOffersStatistics> MAPPER = DataMapper.create(
            F.DATE, F.BUSINESS_ID, F.PARTNER_ID, F.FEED_ID, F.OFFERS, F.ROBOT_OFFERS,
            MarketOffersStatistics::new);

    private interface F {
        Field<LocalDate> DATE = Fields.jodaDateField("date");
        Field<Long> BUSINESS_ID = Fields.longField("business_id");
        Field<Long> PARTNER_ID = Fields.longField("partner_id");
        Field<Long> FEED_ID = Fields.longField("feed_id");
        Field<Long> OFFERS = Fields.longField("offers");
        Field<Long> ROBOT_OFFERS = Fields.longField("robot_offers");
    }
}
