package ru.yandex.webmaster3.storage.geoadv;

import java.util.Map;

import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
public class GeoAdvertisingInfo {
    private Long permalink;
    private GeoAdvertisingResponse geoAdvertisingResponse;

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class GeoAdvertisingResponse{
        private Boolean allowGeoProduct;
        private Boolean allowSubscription;

        private Map<BudgetType, BudgetPrice> geoproduct;
        private Map<BudgetType, BudgetPrice> subscription;

        public GeoAdvertisingResponse(Boolean allowGeoProduct, Boolean allowSubscription) {
            this.allowGeoProduct = allowGeoProduct;
            this.allowSubscription = allowSubscription;
        }

        @Nullable
        public BudgetPrice getMinBudgetPrice() {
            if (subscription != null) {
                return subscription.getOrDefault(BudgetType.MINIMAL, subscription.get(BudgetType.DEFAULT));
            }

            return null;
        }

        @Nullable
        public BudgetPrice getMaxBudgetPrice() {
            if (subscription != null) {
                return subscription.getOrDefault(BudgetType.MAXIMAL, subscription.get(BudgetType.DEFAULT));
            }

            return null;
        }

        public static GeoAdvertisingResponse parseFromJson(JsonNode node) {
            return new GeoAdvertisingResponse(
                    node.get("allowGeoProduct").asBoolean(),
                    node.get("allowSubscription").asBoolean()
            );
        }

    }


    enum BudgetType {
        MINIMAL, MAXIMAL, OPTIMAL, CUSTOM, DEFAULT
    }

    @Data
    @NoArgsConstructor
    public static class Subscription {
        private int amount;
        private double discount;
    }

    @Data
    @NoArgsConstructor
    public static class BudgetPrice {
        private Map<Integer, Subscription> durations;
        private int monthPrediction;
    }
}
