package ru.yandex.webmaster3.storage.history;

import org.joda.time.DateTime;

import java.util.Map;

/**
 * @author avhaliullin
 */
public class IndexingHistoryPoint {
    private final DateTime date;
    private final long docsOnSearch;
    private final Map<Integer, Long> httpCodesCount;

    public IndexingHistoryPoint(DateTime date, long docsOnSearch, Map<Integer, Long> httpCodesCount) {
        this.date = date;
        this.docsOnSearch = docsOnSearch;
        this.httpCodesCount = httpCodesCount;
    }

    public DateTime getDate() {
        return date;
    }

    public long getDocsOnSearch() {
        return docsOnSearch;
    }

    public Map<Integer, Long> getHttpCodesCount() {
        return httpCodesCount;
    }
}
