package ru.yandex.webmaster3.storage.history;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * User: azakharov
 * Date: 25.09.14
 * Time: 15:00
 */
public enum IndexingIndicatorEnum implements IntEnum {
    SEARCH_DOCS_COUNT(0),
    DOWNLOADED_DOCS_COUNT(1),
    EXCLUDED_PAGES_COUNT(2),
    THEMATIC_CITATION_INDEX(3);

    private final int value;

    private IndexingIndicatorEnum(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<IndexingIndicatorEnum> R = IntEnumResolver.r(IndexingIndicatorEnum.class);
}
