package ru.yandex.webmaster3.storage.history;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.storage.history.IndicatorName;

/**
 * User: azakharov
 * Date: 16.02.15
 * Time: 17:27
 */
public class IndicatorNode {
    private final IndicatorName name;
    private final IndicatorName parent;
    private final String url;
    private final boolean leaf;
    private final boolean hasSamples;

    public IndicatorNode(IndicatorName name, IndicatorName parent, String url, boolean leaf, boolean hasSamples) {
        this.name = name;
        this.parent = parent;
        this.url = url;
        this.leaf = leaf;
        this.hasSamples = hasSamples;
    }

    public IndicatorName getName() {
        return name;
    }

    public IndicatorName getParent() {
        return parent;
    }

    public String getUrl() {
        return url;
    }

    @Description("Является ли страница листовой. Данные для листовых страниц получаются с помощью фильтра selected")
    public boolean isLeaf() {
        return leaf;
    }

    @Description("Есть ли для данного показателя примеры URL")
    public boolean isHasSamples() {
        return hasSamples;
    }
}
