package ru.yandex.webmaster3.storage.host;

import java.util.UUID;

import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.link.HostLinkStatisticsGenerationId;
import ru.yandex.webmaster3.core.sitestructure.SiteTreeGenerationId;
import ru.yandex.webmaster3.storage.checklist.data.SummarySiteProblemsInfo;

/**
 * @author avhaliullin
 */
public abstract class AbstractHostDataState {
    protected final WebmasterHostId hostId;
    protected final UUID generationId;
    protected final WebmasterHostId ownerHostId;
    protected final UUID treeGenerationId;
    protected final UUID sitemapGenerationId;
    protected final DateTime closeDate;
    @Deprecated(forRemoval = true) // выпилили отсюда сейчас всегда null
    protected final String displayHostName;
    protected final UUID regionsGenerationId;
    protected final SummarySiteProblemsInfo problemsSummary;
    protected final UUID linksGenerationId;
    protected final UUID threatsGenerationId;

    public AbstractHostDataState(WebmasterHostId hostId, UUID generationId, WebmasterHostId ownerHostId, UUID treeGenerationId,
                                 UUID sitemapGenerationId, DateTime closeDate, String displayHostName, UUID regionsGenerationId,
                                 SummarySiteProblemsInfo problemsSummary, UUID linksGenerationId, UUID threatsGenerationId) {
        this.hostId = hostId;
        this.generationId = generationId;
        this.ownerHostId = ownerHostId;
        this.treeGenerationId = treeGenerationId;
        this.sitemapGenerationId = sitemapGenerationId;
        this.closeDate = closeDate;
        this.displayHostName = displayHostName;
        this.regionsGenerationId = regionsGenerationId;
        this.linksGenerationId = linksGenerationId;
        this.problemsSummary = problemsSummary;
        this.threatsGenerationId = threatsGenerationId;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public UUID getGenerationId() {
        return generationId;
    }

    public DateTime getCloseDate() {
        return closeDate;
    }

    public String getDisplayHostName() {
        return displayHostName;
    }

    @Nullable
    public SiteTreeGenerationId getTreeGenerationId() {
        if (treeGenerationId == null) {
            return null;
        }
        return SiteTreeGenerationId.create(hostId, treeGenerationId);
    }

    public UUID getSitemapGenerationId() {
        return sitemapGenerationId;
    }

    public UUID getRegionsGenerationId() {
        return regionsGenerationId;
    }

    public UUID getThreatsGenerationId() {
        return threatsGenerationId;
    }

    public SummarySiteProblemsInfo getProblemsSummary() {
        return problemsSummary;
    }

    public WebmasterHostId getOwnerHostId() {
        return ownerHostId;
    }

    public HostLinkStatisticsGenerationId getLinksGenerationId() {
        if (linksGenerationId == null) {
            return null;
        }
        return new HostLinkStatisticsGenerationId(hostId, linksGenerationId);
    }
}
