package ru.yandex.webmaster3.storage.host;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * @author aherman
 */
public enum CommonDataType {
    MAIN_MIRRORS_DB,
    PREV_MAIN_MIRRORS_DB,
    LAST_SENT_SEARCH_UPDATE_NOTIFICATION,
    LAST_UPLOADED_NEW_HOSTS,
    MDB_IMPORT_MIRRORS,
    MDB_IMPORT_ALL_MIRRORS,
    IMPORT_MIRRORS,
    LAST_EXPORTED_HOSTS,

    /* THREATS */
    LAST_IMPORTED_OWNER_THREAT_CHANGES,
    RECRAWL_URL_QUOTA_PER_DAY,
    DELURL_URL_QUOTA_PER_DAY,
    DELURL_PREFIX_QUOTA_PER_DAY,
    LAST_SEARCH_BASE_DUMPED_TO_HISTORY,
    MDB_LAST_SEARCH_BASE_DUMPED_TO_HISTORY,
    COUNT_OF_HITS_QUOTA_PER_MINUTE,
    COUNT_OF_HITS_QUOTA_PER_TEN_MINUTES,
    DOWNLOAD_INTERVAL_BETWEEN_INTERNAL_ERRORS_IN_MINUTES,
    NEW_SEARCH_BASE_MAIL_ENABLED,
    LAST_IMPORTANT_URLS_STATUSES_IMPORT2,
    DISABLED_CLICKHOUSE_DC_NAME,
    PRE_DISABLED_CLICKHOUSE_DC_NAME,
    LAST_MORDA_INFO_PROCESSED,
    LAST_METRIKA_STATUS_UPDATE,
    LAST_IMPORTED_STRUCTURES,
    ENABLE_STRUCTURES_PULLING,
    LAST_SENT_DIGEST_DATE,
    BLOCKED_MESSAGE_TYPES,
    LAST_HOSTSTATS_UPDATE,
    DISABLE_REALTIME_URL_ALERT_5XX,
    DISABLE_REALTIME_URL_ALERT_4XX,
    /* TURBO */
    TURBO_FEEDS_API_RESULTS_LAST_IMPORT,
    TURBO_FEEDS_API_DEBUG_RESULTS_LAST_IMPORT,
    TURBO_AUTOPARSED_HOSTS_LAST_IMPORT_DATE,
    TURBO_HOST_STATS_LAST_UPDATE,
    TURBO_ACTIVE_HOSTS_COUNT,
    TURBO_AUTOPARSER_SCREENSHOTS_LAST_UPDATE,
    TURBO_AUTOPARSED_HOSTS_SPEEDS_LAST_UPDATE,
    TURBO_CLICK_DAY_STATS_LAST_UPDATE,
    TURBO_CMNT_URL_LAST_UPDATE,
    LAST_YABROWSER_BADADS_UPDATE,
    SPRAV_COMPANY_INFO_LAST_IMPORT_DATE,
    CRAWL_DELAY_DEFAULT_RPS,
    CRAWL_DELAY_IMPORT_DATE,
    BETA_USERS_LAST_IMPORT_DATE,
    LAST_SITEMAP_FORCE_QUEUE_RECORD_TS,
    LAST_SITEMAP_DATA_EXPORT_DATE,
    LAST_HOST_DATA_EXPORT_DATE,
    GEO_TRIE_GENERATION,
    COUNT_CLOSED_RECOMMENDED,
    DOMAINS_WITH_DIRECT_DYN_ADS_GENERATION,
    DIALOGS_HOSTS_GENERATION,
    COMMERCIAL_OWNERS_GENERATION,
    CHAT_STATS_GENERATION,
    IKS_LAST_IMPORT_DATE,
    ADDURL_LAST_STATE_UPDATE,
    MEMORANDUM_DATA_VERSION,
    MDB_MEMORANDUM_DATA_VERSION,
    ROBOTS_TXT_LAST_TABLE,
    CURRENT_DOMAINS_ON_SEARCH_TABLE,
    LAST_EU_EMAILS_UPDATE,
    SERVICE_SUBSCRIPTION_NOTIFICATION_SWITCH,
    FEEDBACK_LAST_EXPORT_DATE,
    LAST_CREATED_COMPANY_PROFILES_UPDATE,
    METRIKA_CRAWL_SAMPLES_INFO_LAST_UPDATE,
    METRIKA_CRAWL_SAMPLES_LAST_UPDATE,
    EXPERIMENTS_LAST_IMPORT_DATE,
    LAST_ROBOT_CRAWL_WATCHDOG_TABLE_PROCESSED,
    LAST_IMPORT_REVIEW_DATE,
    LAST_SEND_POST_WELCOME_EMAIL_SEND_PROCESS,
    LAST_IMPORTED_HOST_FAVICONS_CHANGES,
    LAST_IKS_VALUE_UPDATE,
    LAST_IKS_PUSH_NOTIFICATION_SEND,
    LAST_IKS_RIVALS_NOTIFICATION_SEND,
    LAST_IMPORTED_TURBO_DOMAINS_STATE_CHANGES,
    LAST_MASS_MEDIA_DICT_IMPORT,
    LAST_POSTPONED_HOST_VERIFY_PROCESSED,
    DIGEST_CUSTOM_BLOCK_EN,
    DIGEST_CUSTOM_BLOCK_RU,
    LAST_INSIGNIFICANT_CGI_PARAMETERS_UPDATE,
    LAST_CALLISTO_IMPORT,
    LAST_FRESH_TABLE_CLEARING,
    TURBO_HOST_BAN,
    LAST_IMPORTED_HOST_PROBLEMS_CHANGES,
    LAST_IMPORTED_SITEMAP_PROBLEMS_CHANGES,
    LAST_IMPORTED_DOMAINS_ON_SEARCH_CHANGES,
    LAST_IMPORTED_SITE_STRUCTURES, // same as LAST_IMPORTED_STRUCTURES but in CH
    LAST_HOST_MOBILE_AUDIT_RESULTS_OVERRIDE_UPDATE,
    LAST_IMPORTED_MIRRORS_CHANGES,
    LAST_PROCESSED_MIRRORS_AUTO_VERIFICATION,
    ENABLE_REALTIME_URL_ALERT_5XX,
    ENABLE_REALTIME_URL_ALERT_4XX,
    LAST_IMPORTED_EXTERNAL_FEEDS,
    LAST_VERSION_FEEDS_PARSE_ERRORS,
    LAST_VERSION_FEEDS_FAST_VERSION_PARSE_ERRORS,
    LAST_BROKEN_LINKS_UPDATE,
    LAST_DEFECT_RATE_IMPORT,
    LAST_FEEDS_OFFERS_STATISTICS_IMPORT,
    LAST_FEEDS_OFFERS_STATISTICS2_IMPORT,
    LAST_MARKET_OFFERS_STATISTICS_IMPORT,
    LAST_PROCESSED_USER_SESSIONS_FEEDS,
    LAST_BAN_OFFERS_IMPORT,
    THRESHOLD_BAD_URLS,
    NCA_CERTIFICATE_LAST_IMPORT,
    NCA_RULES_LAST_IMPORT,
    LAST_RECORD_FROM_CTLOG,
    ;

    public static final EnumResolver<CommonDataType> R = EnumResolver.er(CommonDataType.class);
}
