package ru.yandex.webmaster3.storage.host;

import org.joda.time.DateTime;
import org.joda.time.Instant;
import ru.yandex.webmaster3.core.data.WebmasterHostGeneration;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.link.HostLinkStatisticsGenerationId;
import ru.yandex.webmaster3.core.searchbase.SearchBaseDates;
import ru.yandex.webmaster3.core.sitestructure.SiteTreeGenerationId;
import ru.yandex.webmaster3.storage.checklist.data.SummarySiteProblemsInfo;

import java.util.UUID;

/**
 * @author aherman
 */
public class DoubleSourcedHostDataState extends AbstractHostDataState {
    private final DoubleSourcedIndicatorsDiff doubleSourcedIndicatorsDiff;

    public DoubleSourcedHostDataState(WebmasterHostGeneration webmasterHostGeneration, WebmasterHostId ownerHostId,
                                      SiteTreeGenerationId treeGenerationId, UUID sitemapGenerationId, DateTime closeDate,
                                      String displayHostName, UUID regionsGenerationId, SummarySiteProblemsInfo problemsSummary,
                                      HostLinkStatisticsGenerationId linksGenerationId, UUID threatsGenerationId,
                                      DoubleSourcedIndicatorsDiff doubleSourcedIndicatorsDiff) {
        this(webmasterHostGeneration.getHostId(), webmasterHostGeneration.getGenerationId(), ownerHostId,
                treeGenerationId == null ? null : treeGenerationId.getSiteTreeGenerationId(), sitemapGenerationId,
                closeDate, displayHostName, regionsGenerationId, problemsSummary,
                linksGenerationId == null ? null : linksGenerationId.getLinkGenerationUUID(), threatsGenerationId,
                doubleSourcedIndicatorsDiff);
    }

    public DoubleSourcedHostDataState(WebmasterHostId hostId, UUID generationId, WebmasterHostId ownerHostId, UUID treeGenerationId,
                                      UUID sitemapGenerationId, DateTime closeDate, String displayHostName, UUID regionsGenerationId,
                                      SummarySiteProblemsInfo problemsSummary, UUID linksGenerationId, UUID threatsGenerationId,
                                      DoubleSourcedIndicatorsDiff doubleSourcedIndicatorsDiff) {
        super(hostId, generationId, ownerHostId, treeGenerationId, sitemapGenerationId, closeDate, displayHostName,
                regionsGenerationId, problemsSummary, linksGenerationId, threatsGenerationId);
        this.doubleSourcedIndicatorsDiff = doubleSourcedIndicatorsDiff;
    }

    public DoubleSourcedHostDataState withProblemsSummary(SummarySiteProblemsInfo problemsSummary) {
        return new DoubleSourcedHostDataState(hostId, generationId, ownerHostId, treeGenerationId, sitemapGenerationId, closeDate, displayHostName,
                regionsGenerationId, problemsSummary, linksGenerationId, threatsGenerationId, doubleSourcedIndicatorsDiff);
    }

    public HostDataState toHostDataState(SearchBaseDates searchBaseDates, Instant now) {
        return new HostDataState(hostId, generationId, ownerHostId, treeGenerationId, sitemapGenerationId, closeDate, displayHostName,
                regionsGenerationId, problemsSummary, linksGenerationId, threatsGenerationId, doubleSourcedIndicatorsDiff == null ? null : doubleSourcedIndicatorsDiff.toDiff(searchBaseDates, now));
    }

    public DoubleSourcedIndicatorsDiff getDoubleSourcedIndicatorsDiff() {
        return doubleSourcedIndicatorsDiff;
    }
}
