package ru.yandex.webmaster3.storage.host;

import org.joda.time.Instant;
import ru.yandex.webmaster3.core.searchbase.SearchBaseDates;
import ru.yandex.webmaster3.core.searchbase.SearchBaseSwitchUtil;

/**
 * @author aherman
 */
public class DoubleSourcedIndicatorsDiff {
    private final HostIndicatorsState previousInfo;
    private final HostIndicatorsState currentInfo;
    private final HostIndicatorsState nextBaseInfo;
    private final Instant nextBaseDate;

    public DoubleSourcedIndicatorsDiff(HostIndicatorsState previousInfo, HostIndicatorsState currentInfo, HostIndicatorsState nextBaseInfo, Instant nextBaseDate) {
        this.currentInfo = currentInfo;
        this.previousInfo = previousInfo;
        this.nextBaseInfo = nextBaseInfo;
        this.nextBaseDate = nextBaseDate;
    }

    public HostIndicatorsState getCurrentInfo() {
        return currentInfo;
    }

    public HostIndicatorsState getPreviousInfo() {
        return previousInfo;
    }

    public HostIndicatorsState getNextBaseInfo() {
        return nextBaseInfo;
    }

    public Instant getNextBaseDate() {
        return nextBaseDate;
    }

    public HostIndicatorsState getActualState(SearchBaseDates searchBaseDates, Instant now) {
        return SearchBaseSwitchUtil.selectDoubleSourcedData(currentInfo, nextBaseInfo, nextBaseDate, searchBaseDates, now);
    }

    public HostIndicatorsDiff toDiff(SearchBaseDates searchBaseDates, Instant now) {
        return new HostIndicatorsDiff(getActualState(searchBaseDates, now), previousInfo);
    }

    public static DoubleSourcedIndicatorsDiff fromHostIndicatorsDiff(HostIndicatorsDiff diff) {
        if (diff == null) {
            return null;
        }
        return new DoubleSourcedIndicatorsDiff(
                diff.getPreviousInfo(),
                diff.getCurrentInfo(),
                null,
                null
        );
    }
}
