package ru.yandex.webmaster3.storage.host;

import java.util.UUID;

import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.link.HostLinkStatisticsGenerationId;
import ru.yandex.webmaster3.storage.checklist.data.SummarySiteProblemsInfo;

/**
 * @author aherman
 */
public class HostDataState extends AbstractHostDataState {
    private final HostIndicatorsDiff hostIndicatorsDiff;

    public HostDataState(WebmasterHostId hostId, UUID generationId, WebmasterHostId ownerHostId, UUID treeGenerationId,
                         UUID sitemapGenerationId, DateTime closeDate, String displayHostName, UUID regionsGenerationId,
                         SummarySiteProblemsInfo problemsSummary, UUID linksGenerationId, UUID threatsGenerationId,
                         HostIndicatorsDiff hostIndicatorsDiff) {
        super(hostId, generationId, ownerHostId, treeGenerationId, sitemapGenerationId, closeDate, displayHostName,
                regionsGenerationId, problemsSummary, linksGenerationId, threatsGenerationId);
        this.hostIndicatorsDiff = hostIndicatorsDiff;
    }
    public HostLinkStatisticsGenerationId getLinksGenerationId() {
        if (linksGenerationId == null) {
            return null;
        }
        return new HostLinkStatisticsGenerationId(hostId, linksGenerationId);
    }

    public HostIndicatorsDiff getHostIndicatorsDiff() {
        return hostIndicatorsDiff;
    }
}
